--- Robot Arena 2 GMA Ascii Exporter for 3D Studio MAX v1.4
--- Based on the GMA Ascii Exporter for 3D Studio MAX v0.48
--- Copyright 2003 Slider Vanitose
--- No support is given for using these tools

utility ComponentExport "RA2 Component Export" width:162 height:465
(
	Struct structConstraintSolver (name, body1, body2, spinAxis, posX, posY, posZ)
	fn shape_filt obj = isKindOf obj GeometryClass
	global disCollisionMesh1 = #() -- for output
	global disCollisionMesh2 = #() -- for output
	global displayNameAry= #() -- object names
	global collisionNameAry = #() -- object names
	global collisionMassAry = #() -- for output
	global collisionTot = 0
	function getMatClass str = 
	(
	case str of
	(
	Standardmaterial: Return "Standard"
	multimaterial: Return "Multi/Sub-Object"
	multiSubMaterial: Return "Multi/Sub-Object"
	)
	)
	
	function matFalloff str =
	(
	Case str of
	(
	0: Return "In"
	1: Return "Out"
	)
	)
	
	function mapFilter str =
	(
	Case str of
	(
	0: Return "Pyramidal"
	1: Return "SAT"
	2: Return "None"
	)
	)

	function mapType str =
	(
	Case str of
	(
	0: Return "Spherical"
	1: Return "Cylindrical"
	2: Return "Shrink-Wrap"
	3: Return "Screen"
	)
	)

	function mapClass str =
	(
	Case str of
	(
	Bitmaptexture: Return "Bitmap"
	default: Return "Bitmap"
	)
	)

	function matType str =
	(
	Case str of
	(
	0: Return "Filter" 
	1: Return "Subtractive" 
	2: Return "Additive"
	)
	)

	function hexColor color =
	(
	tmpStr = "0x"
	tmpStr += bit.intAsHex color.b
	tmpStr += bit.intAsHex color.g
	tmpStr += bit.intAsHex color.r
	)

	rollout collisionPairPopup "Collision Pair" width:268 height:163
	(
		spinner spnMass "Mass" pos:[31,136] width:74 height:16 type:#integer scale:1
		label lbl3 "Choose Collision Pair" pos:[2,2] width:269 height:18
		listbox lstMesh1 "Display Mesh" pos:[5,26] width:112 height:6
		listbox lstMesh2 "Collision Mesh" pos:[149,26] width:112 height:6
		button btnOK "OK" pos:[201,135] width:56 height:17
		button BtnCancel "Cancel" pos:[138,135] width:57 height:17
		label lbl4 "<->" pos:[126,76] width:19 height:21
		on collisionPairPopup open do
		(
			if meshAry != undefined then lstMesh1.items = meshAry
			if meshAry != undefined then lstMesh2.items = meshAry
		)
		on btnOK pressed do
		(
			append displayNameAry lstMesh1.selected
			append collisionNameAry lstMesh2.selected
			append collisionMassAry spnMass.value
			collisionTot += 1
			tmpAry = ComponentExport.lstCollisionPairs.items
			append tmpAry (lstMesh1.selected + "<->" + lstMesh2.selected) as string
			ComponentExport.lstCollisionPairs.items = tmpAry
			DestroyDialog collisionPairPopup
		)
		on BtnCancel pressed do
		(
			DestroyDialog collisionPairPopup
		)
	)
	rollout disCollisionPairPopup "Disabled Collision Pair" width:268 height:161
	(
		label lbl3 "Choose Disabled Collision Pair" pos:[2,2] width:269 height:18
		listbox lstMesh1 "Attach Mesh" pos:[145,26] width:112 height:6
		listbox lstMesh2 "Base Mesh" pos:[9,26] width:112 height:6
		button btnOK "OK" pos:[201,135] width:56 height:17
		button BtnCancel "Cancel" pos:[138,135] width:57 height:17
		label lbl4 "<->" pos:[126,76] width:19 height:21
		on disCollisionPairPopup open do
		(
		if meshAry != undefined then lstMesh1.items = meshAry
		if meshAry != undefined then lstMesh2.items = meshAry
		)
		on btnOK pressed do
		(
		if tmpAry != undefined and lstMesh1 != undefined then
		(
		tmpAry = ComponentExport.advanced.lstDisCollisionPairs.items
		append tmpAry (lstMesh1.selected + "<->" + lstMesh2.selected) as string
		append disCollisionMesh1 lstMesh1.selected
		append disCollisionMesh2 lstMesh2.selected
		ComponentExport.advanced.lstDisCollisionPairs.items = tmpAry
		)
		DestroyDialog disCollisionPairPopup
		)
		on BtnCancel pressed do
		(
		DestroyDialog disCollisionPairPopup
		)
	)
	rollout constraintPopup "Constraint Pair" width:229 height:244
	(
		local optionChoose = "X"
		fn pick_filt obj = findString obj.name "Hinge" == 1
		listbox lstBase "Base Mesh" pos:[7,26] width:92 height:5
		listbox lstAttach "Attached Mesh" pos:[128,26] width:92 height:5
		button btnOK "OK" pos:[156,211] width:63 height:23
		label lbl1 "Choose Constraint Pair" pos:[6,4] width:277 height:18
		label lbl4 "-->" pos:[108,74] width:19 height:21
		radiobuttons optAxis "Rotation Axis" pos:[23,132] width:52 height:62 labels:#("X Axis", "Y Axis", "Z Axis") default:1 columns:1
		pickbutton btnPick "Pick Hinge Point" pos:[106,170] width:99 height:16 message:"Pick the Point for the axis.  Must be named Hinge0*" filter:pick_filt
		edittext txtPickName "" pos:[104,141] width:99 height:17
		GroupBox grpAxis "" pos:[7,118] width:213 height:84
		button BtnCancel "Cancel" pos:[91,211] width:57 height:23
		on constraintPopup open do
		(
		lstBase.items = meshAry
		lstAttach.items = meshAry
		)
		on btnOK pressed do
		(
			if txtPickName.text != "" then
			(
			constraintSet = true
			axisConstraint.body1 = lstBase.selected
			axisConstraint.body2 = lstAttach.selected
			axisConstraint.spinAxis = optionChoose
			ComponentExport.advanced.lstConstraintPairs.items = #(axisConstraint.name)
			DestroyDialog constraintPopup
			)
			else
			(
			messageBox "You need to select a 'Hinge' point before you can continue."
			)
		)
		on optAxis changed stat do
	(
			case optAxis.state of 
			( 
			1: optionChoose = "X" 
			2: optionChoose = "Y" 
			3: optionChoose = "Z" 
			)
		)
		on btnPick picked obj do
		(
			txtPickName.text = obj.name
			axisConstraint.name = obj.name
			axisConstraint.posX = obj.pos.x
			axisConstraint.posY = obj.pos.y
			axisConstraint.posZ = obj.pos.z
		)
		on BtnCancel pressed do
		(
			DestroyDialog constraintPopup
		)
	)
	rollout advanced "Component Advanced" width:162 height:370
	(
		listbox lstDisCollisionPairs "" pos:[14,18] width:131 height:4
		GroupBox grp5 "Disabled Collision Pairs" pos:[4,2] width:153 height:105
		button btnAdd "Add" pos:[90,80] width:56 height:16 toolTip:"For adding Mesh pairs that will collide but should not."
		button btnRemove "Remove" pos:[15,80] width:56 height:16 toolTip:""
		--GroupBox grp7 "NodeTM Offset" pos:[4,222] width:154 height:108
		--label lbl2 "x:" pos:[19,238] width:8 height:13
		--edittext offX "0.0" pos:[38,239] width:112 height:17
		--label lbl3 "y:" pos:[20,261] width:8 height:13
		--edittext offY "0.0" pos:[38,263] width:112 height:17
		--label lbl4 "z:" pos:[18,286] width:8 height:13
		--edittext offZ "0.0" pos:[38,286] width:111 height:17
		--button grabTMButton "Grab" pos:[58,307] width:39 height:17 toolTip:"Grab selected objects nodeXYZ"	
		listbox lstConstraintPairs "" pos:[15,128] width:131 height:4
		GroupBox grp4 "Axis Constraints" pos:[5,112] width:153 height:105 enabled:true
		button btnAddConstraint "Add" pos:[91,191] width:56 height:16 toolTip:"For adding axis data for motors."
		button btnRemoveConstraint "Remove" pos:[16,190] width:56 height:16
		on btnAdd pressed do
		(
		if meshAry != undefined do CreateDialog disCollisionPairPopup 
		)
		on btnRemove pressed do
		(
			if lstDisCollisionPairs.selection > 0 then
			(
			deleteItem disCollisionMesh1 lstDisCollisionPairs.selection
			deleteItem disCollisionMesh2 lstDisCollisionPairs.selection
			tmpAry = lstDisCollisionPairs.items
			deleteItem tmpAry lstDisCollisionPairs.selection
			lstDisCollisionPairs.items = tmpAry
			)
		else
			(
			messageBox "You need to select one to remove first."
			)
		)
		--on grabTMButton pressed do
		--(
		--	offX.text = (0 - $.objecttransform.row4.x) as string
		--	offY.text = (0 - $.objecttransform.row4.y) as string
		--	offZ.text = (0 - $.objecttransform.row4.z) as string
		--)
		on btnAddConstraint pressed do
		(
			if constraintSet == true or meshAry == undefined then
			(
			messageBox "The exporter currently supports only one Constraint Pair."
			)
			else
			(
				CreateDialog constraintPopup
			)
		)
		on btnRemoveConstraint pressed do
		(
			if lstConstraintPairs.selection > 0 then
			(
			constraintSet = false
			tmpAry = lstConstraintPairs.items
			deleteItem tmpAry lstConstraintPairs.selection
			lstConstraintPairs.items = tmpAry
			)
		else
			(
			messageBox "You need to select one to remove first."
			)
		)
	)
	rollout sceneStatus "Scene Status" width:162 height:152
	(
		label lbl4 "Object Count:" pos:[8,6] width:69 height:15
		label lbl5 "Attach Count:" pos:[9,23] width:70 height:15
		label lbl6 "Collision Count:" pos:[7,40] width:77 height:15
		label lblObjCount "0" pos:[92,4] width:62 height:15
		label lblAttachCount "0" pos:[92,22] width:62 height:15
		label lblCollCount "0" pos:[92,40] width:62 height:15
		button btnRefresh "Refresh" pos:[37,70] width:82 height:30
		on btnRefresh pressed  do
		(
			lblObjCount.caption = objectCount as string
			if attachAry != undefined then lblAttachCount.caption = attachAry.count as string
			lblCollCount.caption = collisionTot as string
		)
	)
	fn pick_filt obj = findString obj.name "Point" == 1
	pickbutton btnPickPoint "Axis Helper" pos:[14,215] width:131 height:16 filter:pick_filt toolTip:"Used as a reference for your Points"
	GroupBox grp1 "Components" pos:[4,1] width:154 height:70
	checkbox geo_normals "flip normal verts" pos:[15,20] width:97 height:15 toolTip:"May fix lighting problems with large discular objects"
	edittext att_data "Type = " pos:[11,116] width:135 height:17
	button exportAll "Export" pos:[54,42] width:46 height:21 toolTip:"Export Entire Model as an ASCII gmf"
	GroupBox grp2 "Attachments" pos:[4,73] width:154 height:167
	dropdownList attachddl "" pos:[12,88] width:134 height:21
	checkbox chkAxle_F "Axle_F" pos:[10,139] width:54 height:15 checked:false
	checkbox chkBase_F "Base_F" pos:[10,157] width:54 height:15
	checkbox chkGeneric_M "Generic_M" pos:[80,175] width:73 height:15
	checkbox chkAxle_M "Axle_M" pos:[80,139] width:61 height:15
	checkbox chkBase_M "Base_M" pos:[80,157] width:67 height:15
	checkbox chkGeneric_F "Generic_F" pos:[10,175] width:69 height:15
	GroupBox grp3 "Collision Meshes" pos:[4,242] width:154 height:144
	button btnAdd "Add" pos:[87,336] width:57 height:16 toolTip:"Add collision Meshes"
	listbox lstCollisionPairs "" pos:[14,259] width:133 height:5
	
	-- end of main section

	-- event handlers
	
	
	button btnRemove "Remove" pos:[22,336] width:57 height:16 toolTip:"Remove collision Meshes"
	button btnChooseHost "Choose Host Mesh" pos:[15,195] width:128 height:15 toolTip:"Choose the host Mesh for this attachment"
	spinner spnMainMass "Mass of selected = " pos:[70,362] width:75 height:16 range:[0,300,0] type:#integer scale:1
	on ComponentExport open do
	(
	
	addRollout Advanced rolledUp:true
	addRollout sceneStatus rolledUp:true
	
	global axisConstraint = structConstraintSolver "Hinge01" "Mesh1" "Mesh2" "X" 0 0 0 
	global constraintSet = False
	global attachTypeAry = #("Attach") -- for output
	global attachAxleM = #(False) -- for output
	global attachAxleF = #(False) -- for output
	global attachBaseM = #(False) -- for output
	global attachBaseF = #(False) -- for output
	global attachGenericM = #(False) -- for output
	global attachGenericF = #(False) -- for output
	global attachHost = #(" ")
	global collisionAry = #() -- actual objects
	global hasGroups = false
	global groupTot = 0
	global objectCount = 0
	global meshAry = #() -- actual objects
	global attachAry = #()
	
	--reset arrays
	disCollisionMesh1 = #()
	disCollisionMesh2 = #()
	--meshAry = #()
	attachAry = #()
	--collisionTot = 0
	
	for x = 1 to 6 do 
	(
		attachTypeAry[x] = "Attach"
		attachHost[x] = "None"
		attachAxleM[x] = False
		attachAxleF[x] = False
		attachBaseM[x] = False
		attachBaseF[x] = False
		attachGenericM[x] = False
		attachGenericF[x] = False
	)
	
	att_data.text = "Attach"
	
	c = 0
	for obj in $Point* do 
	(
		if classOf obj == point then
		(
		c = c + 1
		attachAry[c] = obj.name
		)
	)	
	attachddl.items = attachAry
	
	c = 0
	
	for obj in objects do 
	(
		if isGroupMember obj or isGroupHead obj do hasGroups = true
		if  not obj.isHidden and not obj.isFrozen  do
		(
			objectCount = objectCount + 1


			if superClassOf obj == GeometryClass and classOf obj != Targetobject then
			(
			append meshAry obj.name
			)
		)
	)
	)
	on ComponentExport close do
	(
		removeRollout sceneStatus
		removeRollout advanced
	)
	on btnPickPoint picked obj do
	(
		p = obj 
		case of 
		( 
		(p == undefined): 
				(
				for objD in helpers do
					(
						if objD.name = "Tape*" then delete objD
					)
				) 
		(p == #rightClick):
				(
				for objD in helpers do
					(
						if objD.name = "Tape*" then delete objD
					)
				) 
		(classOf p == Point):
				(
				tmpPos = [0,0,0]
				tmpPos.x = p.Dir.x
				tmpPos.y = p.Dir.z
				tmpPos.z = p.Dir.y
				tmpPos = (tmpPos * 0.5) + p.pos
				tape pos:p.pos target:(targetObject pos:tmpPos) 
				)
		) 
		)
	on att_data entered text do
	(
	tmp = attachddl.selection
	if tmp != 0 then attachTypeAry[tmp] = att_data.text
	)
	on exportAll pressed do
	(
	
	file_out = getSaveFileName \ 
	types:"gmf(*.gmf)|*.gmf|All|*.*|" 
	if file_out == undefined then return false
	
	fstream = createFile file_out
	
	if fstream == undefined then
	(
		messagebox "Error opening file\n"
		return false
	)
	
	format "GMA\n" to:fstream
	format "*GABRIEL_ASCIIEXPORT	3\n" to:fstream
	format "*MODEL_TYPE	Basic Model\n" to:fstream
	format "*SCENE\n" to:fstream
	format "{\n" to:fstream
	format "	*SCENE_FILENAME	%\n" maxFileName to:fstream
	format "	*SCENE_FIRSTFRAME	0\n" to:fstream
	format "	*SCENE_LASTFRAME	100\n" to:fstream
	format "	*SCENE_FRAMESPEED	30\n" to:fstream
	format "	*SCENE_TICKSPERFRAME	160\n" to:fstream
	format "	*SCENE_BACKGROUND_STATIC	0xffffff\n" to:fstream
	format "	*SCENE_AMBIENT_STATIC	0x191919\n" to:fstream
	format "}\n" to:fstream
	format "*MATERIAL_LIST\n" to:fstream
	format "{\n" to:fstream
	format "	*MATERIAL_COUNT	%\n" sceneMaterials.count to:fstream
	x = 0
	multiMat = false -- for multiple texture loop
	
	--for tmpMat in sceneMaterials do
	for tmpMat in scenematerials do
	(
	--if  not obj.isHidden and not obj.isFrozen  do
	--(
	--tmpMat = obj.material
	
	format "	*MATERIAL\n" to:fstream
	format "	{\n" to:fstream
	
	format "		*MATERIAL_REF_NO	%\n" ((findItem scenematerials tmpMat)-1) to:fstream
	format "		*MATERIAL_NAME	%\n" tmpMat.name to:fstream
	format "		*MATERIAL_CLASS	%\n" (getMatClass (classOf tmpMat)) to:fstream
	if (getMatClass (classOf tmpMat)) == "Multi/Sub-Object" then -- if its multi use first in set for settings
	(
		format "		*MATERIAL_AMBIENT	%\n" (hexColor tmpMat.material1.AMBIENT) to:fstream
		format "		*MATERIAL_DIFFUSE	%\n" (hexColor tmpMat.material1.DIFFUSE) to:fstream
		format "		*MATERIAL_SPECULAR	%\n" (hexColor tmpMat.material1.SPECULAR) to:fstream
		tmpShine = tmpMat.material1.glossiness
		if tmpShine > 9.999999E-02 then tmpShine = 9.999999E-02
		format "		*MATERIAL_SHINE	%\n" tmpShine to:fstream
		format "		*MATERIAL_SHINESTRENGTH	%\n" (tmpMat.material1.specularLevel / 100) to:fstream
		format "		*MATERIAL_TRANSPARENCY	%\n" ((100 - tmpMat.material1.opacity) / 100) to:fstream
		format "		*MATERIAL_WIRESIZE	%\n" tmpMat.material1.wireSize to:fstream
		format "		*MATERIAL_SHADING	%\n" tmpMat.material1.shaderByName to:fstream
		format "		*MATERIAL_XP_FALLOFF	%\n" tmpMat.material1.opacityFallOff to:fstream
		format "		*MATERIAL_SELFILLUM	%\n" (tmpMat.material1.selfIllumAmount / 100) to:fstream
		format "		*MATERIAL_FALLOFF	%\n" (matFalloff tmpMat.material1.opacityFallOffType) to:fstream
		format "		*MATERIAL_XP_TYPE	%\n" (matType tmpMat.material1.opacityType) to:fstream
		format "		*MATERIAL_LIST\n" to:fstream
		format "		{\n" to:fstream
		format "			*MATERIAL_COUNT	%\n" tmpMat.materialList.count to:fstream
	)
	else
	(
		format "		*MATERIAL_AMBIENT	%\n" (hexColor tmpMat.AMBIENT) to:fstream
		format "		*MATERIAL_DIFFUSE	%\n" (hexColor tmpMat.DIFFUSE) to:fstream
		format "		*MATERIAL_SPECULAR	%\n" (hexColor tmpMat.SPECULAR) to:fstream
		tmpShine = tmpMat.glossiness
		if tmpShine > 9.999999E-02 then tmpShine = 9.999999E-02
		format "		*MATERIAL_SHINE	%\n" tmpShine to:fstream

		format "		*MATERIAL_SHINESTRENGTH	%\n" (tmpMat.specularLevel / 100) to:fstream
		format "		*MATERIAL_TRANSPARENCY	%\n" ((100 - tmpMat.opacity) / 100) to:fstream
		format "		*MATERIAL_WIRESIZE	%\n" tmpMat.wireSize to:fstream
		format "		*MATERIAL_SHADING	%\n" tmpMat.shaderByName to:fstream
		format "		*MATERIAL_XP_FALLOFF	%\n" tmpMat.opacityFallOff to:fstream
		format "		*MATERIAL_SELFILLUM	%\n" (tmpMat.selfIllumAmount / 100) to:fstream
		format "		*MATERIAL_FALLOFF	%\n" (matFalloff tmpMat.opacityFallOffType) to:fstream
		format "		*MATERIAL_XP_TYPE	%\n" (matType tmpMat.opacityType) to:fstream
	)
	
	if (getMatClass (classOf tmpMat)) == "Multi/Sub-Object" then
		(
		y = 0
	for subMat in tmpMat.materialList do
		(
		format "			*MATERIAL\n" to:fstream
		format "			{\n" to:fstream
		format "				*MATERIAL_REF_NO	%\n" ((findItem scenematerials subMat)-1) to:fstream
		format "				*MATERIAL_NAME	%\n" subMat.name to:fstream
		format "				*MATERIAL_CLASS	%\n" (getMatClass (classOf subMat)) to:fstream
		format "				*MATERIAL_AMBIENT	%\n" (hexColor subMat.AMBIENT) to:fstream
		format "				*MATERIAL_DIFFUSE	%\n" (hexColor subMat.DIFFUSE) to:fstream
		format "				*MATERIAL_SPECULAR	%\n" (hexColor subMat.SPECULAR) to:fstream
		tmpShine = subMat.glossiness
		if tmpShine > 9.999999E-02 then tmpShine = 9.999999E-02
		format "				*MATERIAL_SHINE	%\n" tmpShine to:fstream 
		format "				*MATERIAL_SHINESTRENGTH	%\n" (subMat.specularLevel /100) to:fstream
		format "				*MATERIAL_TRANSPARENCY	%\n" ((100 - subMat.opacity) / 100) to:fstream
		format "				*MATERIAL_WIRESIZE	%\n" subMat.wireSize to:fstream
		format "				*MATERIAL_SHADING	%\n" subMat.shaderByName to:fstream
		format "				*MATERIAL_XP_FALLOFF	%\n" subMat.opacityFallOff to:fstream
		format "				*MATERIAL_SELFILLUM	%\n" (subMat.selfIllumAmount / 100) to:fstream
		format "				*MATERIAL_FALLOFF	%\n" (matFalloff subMat.opacityFallOffType) to:fstream
		format "				*MATERIAL_XP_TYPE	%\n" (matType subMat.opacityType) to:fstream
	
		mapCount = 0 -- coutn number of textures in material
		mapIndex = #()
		for q = 1 to subMat.Maps.count do
		(
			if subMat.Maps[q] != undefined do 
			(
			mapCount += 1
			mapIndex[mapCount] = q
			)
		)
	
		if mapCount != undefined and mapCount != 0 do
			(
			format "				*TEXTURE_LIST\n" to:fstream
		 	format "				{\n" to:fstream
			format "					*TEXTURE_COUNT	%\n" mapCount to:fstream
		
			c = 0
			tmpMap = ()
			for c = 1 to mapCount do
				(
				tmpIndex = 0
				tmpIndex = mapIndex[c]
				tmpMap = subMat.Maps[tmpIndex]
			
				format "					*TEXTURE\n" to:fstream
				format "					{\n" to:fstream
				format "						*MAP_NAME	%\n" tmpMap.name to:fstream
				format "						*MAP_CLASS	%\n" (mapClass (classOf tmpMap)) to:fstream
				format "						*BITMAP	%\n" (filenameFromPath tmpMap.filename) to:fstream
				format "						*MAP_AMOUNT	1.000000\n" to:fstream
				format "						*MAP_DIFFUSE\n" to:fstream
				format "						*MAP_TYPE	%\n" (MapType tmpMap.coordinates.mappingType) to:fstream
				format "						*UVW_U_OFFSET	%\n" (tmpMap.coordinates.U_Offset) to:fstream
				format "						*UVW_V_OFFSET	%\n" (tmpMap.coordinates.V_Offset) to:fstream
				format "						*UVW_U_TILING	%\n" (tmpMap.coordinates.U_Tiling) to:fstream
				format "						*UVW_V_TILING	%\n" (tmpMap.coordinates.V_Tiling) to:fstream
				format "						*UVW_ANGLE	0.000000\n" to:fstream
				format "						*UVW_BLUR	%\n" (tmpMap.coordinates.Blur) to:fstream
				format "						*UVW_BLUR_OFFSET	%\n" (tmpMap.coordinates.Blur_Offset) to:fstream
				format "						*UVW_NOISE_AMT	%\n" (tmpMap.coordinates.Noise_Amount) to:fstream
				format "						*UVW_NOISE_SIZE	%\n" (tmpMap.coordinates.Noise_Size) to:fstream
				format "						*UVW_NOISE_LEVEL	%\n" (tmpMap.coordinates.Noise_Levels) to:fstream
				format "						*UVW_NOISE_PHASE	%\n" (tmpMap.coordinates.Phase) to:fstream
				format "						*BITMAP_FILTER	%\n" (mapFilter tmpMap.filtering) to:fstream
				format "						*BITMAP_MAP_CHANNEL	1\n" to:fstream
				format "					}\n" to:fstream
				) -- end individual textures loop
			format "				}\n" to:fstream
			) -- end texture list block
	
			
		format "			}\n" to:fstream
		y = y + 1
		)
		format "		}\n" to:fstream
		format "	}\n" to:fstream
	)
	
	if (getMatClass (classOf tmpMat)) != "Multi/Sub-Object" then
	(
		mapCount = 0 -- coutn number of textures in material
		mapIndex = #()
		for x = 1 to tmpMat.Maps.count do
		(
			if tmpMat.Maps[x] != undefined do 
			(
			mapCount += 1
			mapIndex[mapCount] = x
			)
		)
	
	if mapCount != undefined and mapCount != 0 do
		(
		format "		*TEXTURE_LIST\n" to:fstream
		format "		{\n" to:fstream
		format "			*TEXTURE_COUNT	%\n" mapCount to:fstream
	
		c = 0
		tmpMap = ()
		for c = 1 to mapCount do
		(
			tmpIndex = 0
			tmpIndex = mapIndex[c]
			tmpMap = tmpMat.Maps[tmpIndex]
			
			format "			*TEXTURE\n" to:fstream
			format "			{\n" to:fstream
			format "				*MAP_NAME	%\n" tmpMap.name to:fstream
			format "				*MAP_CLASS	%\n" (mapClass (classOf tmpMap)) to:fstream
			format "				*BITMAP	%\n" (filenameFromPath tmpMap.filename) to:fstream
			format "				*MAP_AMOUNT	1.000000\n" to:fstream
			format "				*MAP_DIFFUSE\n" to:fstream
			format "				*MAP_TYPE	%\n" (MapType tmpMap.coordinates.mappingType) to:fstream
			format "				*UVW_U_OFFSET	%\n" (tmpMap.coordinates.U_Offset) to:fstream
			format "				*UVW_V_OFFSET	%\n" (tmpMap.coordinates.V_Offset) to:fstream
			format "				*UVW_U_TILING	%\n" (tmpMap.coordinates.U_Tiling) to:fstream
			format "				*UVW_V_TILING	%\n" (tmpMap.coordinates.V_Tiling) to:fstream
			format "				*UVW_ANGLE	0.000000\n" to:fstream
			format "				*UVW_BLUR	%\n" (tmpMap.coordinates.Blur) to:fstream
			format "				*UVW_BLUR_OFFSET	%\n" (tmpMap.coordinates.Blur_Offset) to:fstream
			format "				*UVW_NOISE_AMT	%\n" (tmpMap.coordinates.Noise_Amount) to:fstream
			format "				*UVW_NOISE_SIZE	%\n" (tmpMap.coordinates.Noise_Size) to:fstream
			format "				*UVW_NOISE_LEVEL	%\n" (tmpMap.coordinates.Noise_Levels) to:fstream
			format "				*UVW_NOISE_PHASE	%\n" (tmpMap.coordinates.Phase) to:fstream
			format "				*BITMAP_FILTER	%\n" (mapFilter tmpMap.filtering) to:fstream
			format "				*BITMAP_MAP_CHANNEL	1\n" to:fstream
			format "			}\n" to:fstream
		) -- end individual textures loop
		format "		}\n" to:fstream
		) -- end texture list block
		--) --  end of if multi block
		format "	}\n" to:fstream
	x = x + 1
	)
	) -- end Material block
	format "}\n" to:fstream
	
	
	
	format "*OBJECT_LIST\n" to:fstream
	format "{\n" to:fstream
		format "	*OBJECT_COUNT	%\n" (objectCount + 2) to:fstream
	
	--process constraints
	for obj in $Hinge* do 
	(
	if classOf obj == point and ComponentExport.advanced.lstConstraintPairs.items.count > 0 then
	(
		format "	*GMID_HAVOK_CONSTRAINTSOLVER\n" to:fstream
		format "	{\n" to:fstream
		format "		*NODE_NAME	CSolver01\n" to:fstream
		format "		*THRESHOLD	10\n" to:fstream
		format "		*RB_COLLECTION_NAME	RBCollection01\n" to:fstream
		format "		*GMID_HAVOK_CONSTRAINT_LIST\n" to:fstream
		format "		{\n" to:fstream
		format "			*COUNT	1\n" to:fstream
		format "			*GMID_HAVOK_HINGE_CONSTRAINT\n" to:fstream
		format "			{\n" to:fstream
		format "				*NODE_NAME	Hinge01\n" to:fstream
		format "				*NODE_TM\n" to:fstream
		format "				{\n" to:fstream
		format "					*NODE_NAME	Hinge01\n" to:fstream
		format "					*TM_ROW0 %	%	%\n" (0 + obj.objecttransform.row1.x) (0 + obj.objecttransform.row1.y) (0 + obj.objecttransform.row1.z) to:fstream
		format "					*TM_ROW1 %	%	%\n" (0 + obj.objecttransform.row2.x) (0 + obj.objecttransform.row2.y) (0 + obj.objecttransform.row2.z) to:fstream
		format "					*TM_ROW2 %	%	%\n" (0 + obj.objecttransform.row3.x) (0 + obj.objecttransform.row3.y) (0 + obj.objecttransform.row3.z) to:fstream
		format "					*TM_ROW3 %	%	%\n" (0 + obj.objecttransform.row4.x) (0 - obj.objecttransform.row4.z) (0 + obj.objecttransform.row4.y) to:fstream
		format "				}\n" to:fstream
		format "				*BODY1	%\n" axisConstraint.body1 to:fstream
		format "				*BODY2	%\n" axisConstraint.body2 to:fstream
		format "				*POINT %	%	%\n" (0 + obj.objecttransform.row4.x) (0 - obj.objecttransform.row4.z) (0 + obj.objecttransform.row4.y) to:fstream
		case axisConstraint.spinaxis of
		(
		"X":format "				*SPIN_AXIS -1	0	0\n" to:fstream
		"Y":format "				*SPIN_AXIS 0	-1	0\n" to:fstream
		"Z":format "				*SPIN_AXIS 0	0	-1\n" to:fstream
		)
		format "				*IS_LIMITED 0\n" to:fstream
		format "				*FRICTION 0\n" to:fstream
		format "				*ANGLE_LIMITS -1.570796	1.570796\n" to:fstream
		format "			}\n" to:fstream
		format "		}\n" to:fstream
		format "	}\n" to:fstream
	)
	)
	

	
	
	-- process all geometry except hidden and frozen
	for obj in objects do 
	(
	if not obj.isHidden and not obj.isFrozen  do
	(
		if isGroupHead obj do
		(
		format "	*GEOMOBJECT\n	{\n" to:fstream
		format "		*NODE_NAME	%\n" obj.name to:fstream
	
		format "		*NODE_SHADEVERTS	0\n" to:fstream
		format "		*NODE_TM\n		{\n" to:fstream
		format "			*NODE_NAME	%\n" obj.name to:fstream
		format "			*TM_ROW0 %	%	%\n" (0 + obj.objecttransform.row1.x) (0 + obj.objecttransform.row1.y) (0 + obj.objecttransform.row1.z) to:fstream
		format "			*TM_ROW1 %	%	%\n" (0 + obj.objecttransform.row2.x) (0 + obj.objecttransform.row2.y) (0 + obj.objecttransform.row2.z) to:fstream
		format "			*TM_ROW2 %	%	%\n" (0 + obj.objecttransform.row3.x) (0 + obj.objecttransform.row3.y) (0 + obj.objecttransform.row3.z) to:fstream
		format "			*TM_ROW3 %	%	%\n" (0 + obj.objecttransform.row4.x + obj.objecttransform.row4.x) (0 - obj.objecttransform.row4.z - obj.objecttransform.row4.z) (0 + obj.objecttransform.row4.y + obj.objecttransform.row4.y) to:fstream
		format "		}\n" to:fstream
		format "		*MESH\n		{\n" to:fstream
		format "			*TIMEVALUE	0\n" to:fstream
		format "			*MESH_NUMVERTEX	0\n" to:fstream
		format "			*MESH_NUMFACES	0\n" to:fstream
		format "			*MESH_VERTEX_LIST\n			{\n" to:fstream
		format "			}\n" to:fstream
		format "			*MESH_FACE_LIST\n			{\n" to:fstream
		format "			}\n" to:fstream
		format "			*BACKFACE_CULL	1\n" to:fstream
		format "			*MATERIAL_REF	0\n" to:fstream
		format "		}\n" to:fstream
		format "	}\n" to:fstream
		groupTot += 1
		)
	)
	)
	for obj in geometry do 
	(
	if  not obj.isHidden and not obj.isFrozen  do
		(
		geo = obj.mesh
		format "	*GEOMOBJECT\n	{\n" to:fstream
		format "		*NODE_NAME	%\n" obj.name to:fstream
		if isGroupMember obj do format "		*NODE_PARENT	%\n" obj.parent.name to:fstream
		format "		*NODE_SHADEVERTS	0\n" to:fstream
		format "		*NODE_TM\n		{\n" to:fstream
		format "			*NODE_NAME	%\n" obj.name to:fstream
		format "			*TM_ROW0 %	%	%\n" (0 + obj.objecttransform.row1.x) (0 + obj.objecttransform.row1.y) (0 + obj.objecttransform.row1.z) to:fstream
		format "			*TM_ROW1 %	%	%\n" (0 + obj.objecttransform.row2.x) (0 + obj.objecttransform.row2.y) (0 + obj.objecttransform.row2.z) to:fstream
		format "			*TM_ROW2 %	%	%\n" (0 + obj.objecttransform.row3.x) (0 + obj.objecttransform.row3.y) (0 + obj.objecttransform.row3.z) to:fstream
		format "			*TM_ROW3 %	%	%\n" (0 + obj.objecttransform.row4.x) (0 + obj.objecttransform.row4.z) (0 + obj.objecttransform.row4.y) to:fstream
		--format "			*TM_ROW3 %	%	%\n" (0 + obj.objecttransform.row4.x + obj.objecttransform.row4.x) (0 - obj.objecttransform.row4.z - obj.objecttransform.row4.z) (0 + obj.objecttransform.row4.y + obj.objecttransform.row4.y) to:fstream
		format "		}\n" to:fstream
		format "		*MESH\n		{\n" to:fstream
		format "			*TIMEVALUE	%\n" currenttime.ticks to:fstream
		format "			*MESH_NUMVERTEX	%\n" geo.numVerts to:fstream
		format "			*MESH_NUMFACES	%\n" geo.numFaces to:fstream
	
		format "			*MESH_VERTEX_LIST\n			{\n" to:fstream
		for i = 1 to geo.numVerts do
		(
			local vert = getVert geo i
			format "				*MESH_VERTEX	%	%	%	%\n" (I-1) vert.x vert.z vert.y to:fstream
		)
		format "			}\n" to:fstream
	
		format "			*MESH_FACE_LIST\n			{\n" to:fstream
		for i = 1 to geo.numfaces do
		(
			local vert = getFace geo i
			format "				*MESH_FACE	%	A:%	B:%	C:%	*MESH_MTDLID %\n" (I-1) (vert.x as integer -1) (vert.y as integer -1) (vert.z as integer-1) (getfacematid geo i as integer - 1) to:fstream
		)
		format "			}\n" to:fstream
	
		if geo.numtverts != 0 then
		(
		format "			*MESH_NUMTVERTEX	%\n" geo.numtVerts to:fstream
		format "			*MESH_TVERTLIST\n			{\n" to:fstream
		for i = 1 to geo.numtVerts do
		(
			local vert = getTVert geo i
			format "				*MESH_TVERT	%	%	%	%\n" (I-1) vert.x vert.y vert.z to:fstream
		)
		format "			}\n" to:fstream
		format "			*MESH_NUMTVFACES	%\n" geo.numfaces to:fstream
		format "			*MESH_TFACELIST\n			{\n" to:fstream
		for i = 1 to geo.numfaces do
		(
			local vert = getTVface geo i
			format "				*MESH_TFACE	%	%	%	%\n" (I-1) (vert.x as integer - 1) (vert.y as integer - 1) (vert.z as integer - 1) to:fstream
		)
		format "			}\n" to:fstream
		)
	
		format "			*MESH_NORMALS\n			{\n" to:fstream
		for i = 1 to geo.numfaces do
		(
			local vert = getFace geo i
			format "				*MESH_FACENORMAL	%	%	%	%\n" (I-1) (0 + (getfacenormal geo i).x) (0 + (getfacenormal geo i).y) (0 + (getfacenormal geo i).z) to:fstream
		
			if geo_normals.checked == false then
			(
			format "					*MESH_VERTEXNORMAL	%	%	%	%\n" (vert.x as integer -1) (0 - (getnormal geo vert.x).x) (0 - (getnormal geo vert.x).y) (0 - (getnormal geo vert.x).z) to:fstream
			format "					*MESH_VERTEXNORMAL	%	%	%	%\n" (vert.y as integer -1) (0 - (getnormal geo vert.y).x) (0 - (getnormal geo vert.y).y) (0 - (getnormal geo vert.y).z) to:fstream
			format "					*MESH_VERTEXNORMAL	%	%	%	%\n" (vert.z as integer -1) (0 - (getnormal geo vert.z).x) (0 - (getnormal geo vert.z).y) (0 - (getnormal geo vert.z).z) to:fstream
			)
			if geo_normals.checked == true then
			(
			format "					*MESH_VERTEXNORMAL	%	%	%	%\n" (vert.x as integer -1) (0 + (getnormal geo vert.x).x) (0 + (getnormal geo vert.x).z) (0 + (getnormal geo vert.x).y) to:fstream
			format "					*MESH_VERTEXNORMAL	%	%	%	%\n" (vert.y as integer -1) (0 + (getnormal geo vert.y).x) (0 + (getnormal geo vert.y).z) (0 + (getnormal geo vert.y).y) to:fstream
			format "					*MESH_VERTEXNORMAL	%	%	%	%\n" (vert.z as integer -1) (0 + (getnormal geo vert.z).x) (0 + (getnormal geo vert.z).z) (0 + (getnormal geo vert.z).y) to:fstream
			)
		)
		format "			}\n" to:fstream
	
		format "			*BACKFACE_CULL	1\n" to:fstream
	if obj.material != undefined then 
	(
	matRef = (findItem scenematerials obj.material)-1
	)
	else 	( 
	matRef = "0" 
	)
		format "			*MATERIAL_REF	%\n" matRef to:fstream
	
		format "		}\n" to:fstream
		format "	}\n" to:fstream
		)
	)
	
	
	-- process helpers (ie. points)
	
	tmp = 0
	for obj in $Point* do 
	(
		if classOf obj == point then
		(
		tmp = tmp + 1
		format "	*GMID_ATTACHMENTPT\n	{\n" to:fstream
		format "		*NODE_NAME	%\n" obj.name to:fstream
		 	format "		*NODE_TM\n		{\n" to:fstream
		format "			*NODE_NAME	%\n" obj.name to:fstream
		format "			*TM_ROW0 %	%	%\n" (0 + obj.objecttransform.row1.x) (0 + obj.objecttransform.row1.y) (0 + obj.objecttransform.row1.z) to:fstream
		format "			*TM_ROW1 %	%	%\n" (0 + obj.objecttransform.row2.x) (0 + obj.objecttransform.row2.y) (0 + obj.objecttransform.row2.z) to:fstream
		format "			*TM_ROW2 %	%	%\n" (0 + obj.objecttransform.row3.x) (0 + obj.objecttransform.row3.y) (0 + obj.objecttransform.row3.z) to:fstream
		format "			*TM_ROW3 %	%	%\n" (0 + obj.objecttransform.row4.x) (0 + obj.objecttransform.row4.z) (0 + obj.objecttransform.row4.y) to:fstream
		format "		}\n" to:fstream
		format "		USER DATA	Type = %\n" attachTypeAry[tmp] to:fstream
		format "ID = %\n" tmp to:fstream
		tmpStr = ""
		tmpMult = False
		if attachBaseF[tmp] do
		(
			tmpStr = "Base_F"
			tmpMult = True 
		)
		if attachBaseM[tmp] do
		(
			if tmpMult then tmpStr = tmpStr + ", "
			tmpStr = tmpStr + "Base_M"
			tmpMult = True 
		)
		if attachAxleF[tmp] do
		(
			if tmpMult then tmpStr = tmpStr + ", "
			tmpStr = tmpStr + "Axle_F"
			tmpMult = True 
		)
		if attachAxleM[tmp] do
		(
			if tmpMult then tmpStr = tmpStr + ", "
			tmpStr = tmpStr + "Axle_M"
			tmpMult = True 
		)
		if attachGenericF[tmp] do
		(
			if tmpMult then tmpStr = tmpStr + ", "
			tmpStr = tmpStr + "Generic_F"
			tmpMult = True 
		)
		if attachGenericM[tmp] do
		(
			if tmpMult then tmpStr = tmpStr + ", "
			tmpStr = tmpStr + "Generic_M"
			tmpMult = True 
		)
		if tmpStr != "" do format "Attach = %\n" tmpStr to:fstream
		if attachHost[tmp] != "None" do format "Host = %\n" attachHost[tmp] to:fstream
		format "	}\n" to:fstream
		)
	)
	
	
	format "	*GMID_HAVOK_SIMOBJECT\n" to:fstream
	

	format "	{\n" to:fstream
	format "		*NODE_NAME	(null)\n" to:fstream
	format "		*GRAVITY	0.000000 -9.809980 0.000000\n" to:fstream
	format "		*WORLDSCALE	39.369999\n" to:fstream
	format "		*SIMTOLERANCE	0.100000\n" to:fstream
	format "		*RESOLVER	3\n" to:fstream
	format "		*INCLUDE_DRAG	0\n" to:fstream
	format "		*LINEAR_DRAG	0.000000\n" to:fstream
	format "		*ANGULAR_DRAG	0.000000\n" to:fstream
	format "		*INCLUDE_DEACTIVATOR	1\n" to:fstream
	format "		*SHORTFREQ	5.000000\n" to:fstream
	format "		*LONGFREQ	0.100000\n" to:fstream
	format "		*USE_FAST_SUBSPACE	1\n" to:fstream
	format "		*UPDATES_PER_TIMESTEP	1.000000\n" to:fstream
	format "		*NUM_COLLISION_PAIRS	0\n" to:fstream
	format "	}\n" to:fstream
	format "	*GMID_HAVOK_RBCOLLECTION\n" to:fstream
	format "	{\n" to:fstream
	format "		*NODE_NAME	RBCollection01\n" to:fstream
	disCollisionTotal = ComponentExport.advanced.lstDisCollisionPairs.items.count
	format "		*NUM_DISABLED_PAIRS	%\n" disCollisionTotal to:fstream
	format "		*SOLVER_TYPE	0\n" to:fstream
	format "		*COUNT	%\n" collisionTot to:fstream
	format "		*GMID_HAVOK_RIGIDBODY_LIST\n" to:fstream
	format "		{\n" to:fstream
	format "			*COUNT	%\n" collisionTot to:fstream
	
	for obj in objects do
	(
	if  not obj.isHidden and not obj.isFrozen  do
	(
	for x = 1 to collisionTot do
	(
	tmpStr = " "
	tmpStr = displayNameAry[x]
	if obj.name == tmpStr then
	(
	format "			*GMID_HAVOK_RIGIDBODY\n" to:fstream
	format "			{\n" to:fstream
	format "				*NODE_NAME	%\n" displayNameAry[x] to:fstream
	format "				*MASS	%\n" collisionMassAry[x] to:fstream
	format "				*ELASTICITY	0.300000\n" to:fstream
	format "				*FRICTION	0.8\n" to:fstream
	format "				*OPTIMIZATION_LEVEL	0.500000\n" to:fstream
	format "				*UNYIELDING	0\n" to:fstream
	format "				*SIMULATION_GEOMETRY	3\n" to:fstream
	format "				*GEOMETRY_PROXY_NAME	%\n" collisionNameAry[x] to:fstream
	format "				*USE_DISPLAY_PROXY	0\n" to:fstream
	format "				*DISABLE_COLLISIONS	0\n" to:fstream
	format "				*INACTIVE	0\n" to:fstream
	format "				*DISPLAY_PROXY_NAME	(null)\n" to:fstream
	format "				*NODE_TM\n" to:fstream
	format "				{\n" to:fstream
	format "					*NODE_NAME	%\n" displayNameAry[x] to:fstream
	format "					*TM_ROW0 %	%	%\n" (0 + obj.objecttransform.row1.x) (0 + obj.objecttransform.row1.y) (0 + obj.objecttransform.row1.z) to:fstream
	format "					*TM_ROW1 %	%	%\n" (0 + obj.objecttransform.row2.x) (0 + obj.objecttransform.row2.y) (0 + obj.objecttransform.row2.z) to:fstream
	format "					*TM_ROW2 %	%	%\n" (0 + obj.objecttransform.row3.x) (0 + obj.objecttransform.row3.y) (0 + obj.objecttransform.row3.z) to:fstream
	format "					*TM_ROW3 %	%	%\n" (0 + obj.objecttransform.row4.x) (0 + obj.objecttransform.row4.z) (0 + obj.objecttransform.row4.y) to:fstream
	format "				}\n" to:fstream
	format "				*HAVOK_GEO_TYPE	Standard\n" to:fstream
	format "				*NUMBER_OF_CHILDREN	0\n" to:fstream
	format "			}\n" to:fstream
	)
	)
	)
	)
	format "		}\n" to:fstream
	if disCollisionTotal > 0 then
	(
	format "		*GMID_HAVOK_DIS_COLLISION_PAIRS\n" to:fstream
	format "		{\n" to:fstream
	format "			*COUNT	%\n" disCollisionTotal to:fstream
	for y = 1 to disCollisionTotal  do
		(
		format "			{ %	%  }\n" disCollisionMesh1[y] disCollisionMesh2[y]  to:fstream
		)
	format "		}\n" to:fstream
	)
	format "	}\n" to:fstream
	format "}\n" to:fstream
	
	close fstream
	
	messagebox "File saved successfully"	
	)
	on attachddl selected sel do
	(
		tmpStr = attachddl.selected
		tmpNode = getNodeByName tmpStr
		select tmpNode
	
		tmp = attachddl.selection
		if tmp != 0 then
		(
		att_data.text = attachTypeAry[tmp]
		chkBase_F.checked = attachBaseF[tmp]
		chkBase_M.checked = attachBaseM[tmp]
		chkAxle_F.checked = attachAxleF[tmp]
		chkAxle_M.checked = attachAxleM[tmp]
		chkGeneric_F.checked = attachGenericF[tmp]
		chkGeneric_M.checked = attachGenericM[tmp]
		)
	)
	on chkAxle_F changed state do
	(
		tmp = attachddl.selection
		if tmp != 0 then attachAxleF[tmp] = chkAxle_F.state
	)
	on chkBase_F changed state do
	(
		tmp = attachddl.selection
		if tmp != 0 then attachBaseF[tmp] = chkBase_F.state
	
	)
	on chkGeneric_M changed state do
	(
		tmp = attachddl.selection
		if tmp != 0 then attachGenericM[tmp] = chkGeneric_M.state
	)
	on chkAxle_M changed state do
	(
		tmp = attachddl.selection
		if tmp != 0 then attachAxleM[tmp] = chkAxle_M.state
	)
	on chkBase_M changed state do
	(
		tmp = attachddl.selection
		if tmp != 0 then attachBaseM[tmp] = chkBase_M.state
	)
	on chkGeneric_F changed state do
	(
		tmp = attachddl.selection
		if tmp != 0 then attachGenericF[tmp] = chkGeneric_F.state
	)
	on btnAdd pressed do
	(
		if meshAry != undefined do CreateDialog collisionPairPopup 
	)
	on lstCollisionPairs selected sel do
	(
	spnMainMass.value = collisionMassAry[lstCollisionPairs.selection]
	)
	on btnRemove pressed do
	(
		if lstCollisionPairs.selection > 0 then
		(
			deleteItem displayNameAry lstCollisionPairs.selection
			deleteItem collisionNameAry lstCollisionPairs.selection
			deleteItem collisionMassAry lstCollisionPairs.selection
			tmpAry = lstCollisionPairs.items
			deleteItem tmpAry lstCollisionPairs.selection
			lstCollisionPairs.items = tmpAry
			collisionTot -= 1
		)
		else
		(
			messageBox "You need to select one to remove first."
		)
	)
	on btnChooseHost pressed do
	(
		if meshAry != undefined then
		(
		tmpStr = selectByName title:"Select the host mesh for your point" single:True filter:shape_filt
		if tmpStr != undefined then
		(
		if attachddl.selection != 0 then attachHost[attachddl.selection] = tmpStr.Name
		)
		else
		(
		if attachddl.selection != 0 then attachHost[attachddl.selection] = "None"
		)
		)
	)
	on spnMainMass changed val do
	(
		collisionMassAry[lstCollisionPairs.selection] = spnMainMass.value
	)
)